var samplePageObj = {

  externalScript: ['../assets/ibsheet/plugins/ibsheet-excel.js'],

  // 샘플 타이틀
  title: '파일 내보내기(다운로드) 예제',
  subtitle: '시트내에 데이터를 다운로드 합니다.',
  // 샘플 설명
  desc: 'down2Excel(),down2Text() 등의 함수를 통해서 시트 내에 데이터를 외부파일로 다운로드 하실 수 있습니다.<br>import/export 관련 기능을 사용시에는 <strong>ibsheet-excel.js</strong> 파일이 include 되어야 합니다.',

  // 객체 초기화 구문
  init: {
    Cfg: {
      SearchMode: 0,
      HeaderMerge: 6,
      FitWidth: 1,
      Export: { Url: (location.href.indexOf('localhost') > -1 ? '../jsp/' : 'https://api.ibleaders.com/ibsheet/v8/') }, // 다운 jsp URL
    },
    Cols: [
      {
        Header: [
          '신청인',
          '신청인'
        ],
        Type: 'Text',
        MinWidth: 80,
        Name: 'sName',
        ColMerge: 1
      },
      {
        Header: [
          '선택',
          '선택'
        ],
        Type: 'Bool',
        MinWidth: 80,
        Name: 'check',
        ColMerge: 1
      },
      {
        Header: [
          '신청사유',
          '신청사유'
        ],
        Type: 'Enum',
        MinWidth: 80,
        Name: 'Reason',
        ColMerge: 0,
        Align: 'Center',
        Enum: '|야근|주말특근|휴일특근',
        EnumKeys: '|01|02|03'
      },
      {
        Header: [
          '신청금액',
          '신청금액'
        ],
        Type: 'Int',
        MinWidth: 85,
        Name: 'Qty',
        ColMerge: 1,
        Required: 1
      },
      {
        Header: [
          '근태기간',
          '시작일'
        ],
        Name: 'Date1',
        Extend: IB_Preset.YMD
      },
      {
        Header: [
          '근태기간',
          '종료일'
        ],
        Name: 'Date2',
        Extend: IB_Preset.YMD
      },
      {
        Header: [
          '시간',
          '시작'
        ],
        Name: 'Time1',
        Extend: IB_Preset.HM
      },
      {
        Header: [
          '시간',
          '종료'
        ],
        Name: 'Time2',
        Extend: IB_Preset.HM
      },
      {
        Header: [
          'rDate',
          'rDate'
        ],
        Name: 'rDate',
        Extend: IB_Preset.YMD,
        Visible: 0
      },
      {
        Header: [
          'chk',
          'chk'
        ],
        Name: 'chk',
        Type: 'Bool',
        Visible: 0
      }
    ],
  },

  // 버튼/기능 영역 html (sampleBtn으로 호출하면 action함수로 연결)
  func: '<div><label>내려받을 파일명:</label><input type=\'text\' class=\'mgr10\' id=\'filename\' style=\'width:280px\'></div>'
  + '<div><button type=\'button\' class=\'mgr10\' onclick=\'sampleBtn(this)\'>엑셀파일 내보내기</button><button type=\'button\' class=\'mgr10\' onclick=\'sampleBtn(this)\'>CSV 형식으로 내보내기</button>'
  + '<button type=\'button\' class=\'mgr10\' onclick=\'sampleBtn(this)\'>txt 형식으로 내보내기</button></div>'
  // <button type=\'button\' class=\'mgr10\' onclick=\'sampleBtn(this)\'>HML 형식으로 내보내기</button>
  // <button type=\'button\' class=\'mgr10\' onclick=\'sampleBtn(this)\'>PDF 형식으로 내보내기</button>
  + '<div><button type=\'button\' class=\'mgr10\' onclick=\'sampleBtn(this)\'>다운로드 다이얼로그</button></div>',

  // 객체 생성 Html
  objEl: '<div id=\'sheetDiv\' style=\'width:100%;height:100%\'></div>',

  // 시트 하단 영역 html
  footer: '',

  // 객체 생성 구문
  create: function () {
    document.getElementById('filename').value = IBSheet.dateToString(new Date(), 'yyyy-MM-dd HH:mm') + '_IBSheet엑셀 예제';
    var options = this.init;

    options.Events = this.event;
    IBSheet.create({
      id: 'sheet', // 생성할 시트의 id
      el: 'sheetDiv', // 시트를 생성할 Dom 객체 및 id
      options: options, // 생성될 시트의 속성
      data: this.data // 생성될 시트의 정적데이터
    });
    sheet.Name = '엑셀다운로드 예제';
  },
  // 버튼 클릭시 기능 로직
  action: function (obj) {
    switch (obj.textContent) {
      case '엑셀파일 내보내기':
        sheet.down2Excel({
          sheetDesign: 0,
          merge: 1,
          fileName: document.getElementById('filename').value + '.xlsx'
        });
        break;
      case 'CSV 형식으로 내보내기':
        sheet.down2Text({
          colDelim: ',',
          fileName: document.getElementById('filename').value + '.csv'
        });
        break;
      case 'txt 형식으로 내보내기':
        sheet.down2Text({ fileName: document.getElementById('filename').value + '.txt' });
        break;
      case '다운로드 다이얼로그':
        sheet.showExcelDownloadDialog();
        break;
      // no default
    }
  },

  // event구문
  event: {
    onBeforeExport: function (evtParam) {
      console.log(evtParam.eventName + ' 발생');
    },
    onExportFinish: function (evtParam) {
      console.log(evtParam.eventName + ' 발생');
    }
  },

  // data
  data: [
    {
      Reason: '01',
      sName: '강인철',
      rDate: '20030908',
      chk: 0,
      Qty: 545000,
      Time1: '1300',
      Time2: '1800'
    },
    {
      Reason: '01',
      sName: '김수용',
      rDate: '20030906',
      chk: 1,
      Qty: 500000,
      Date1: '20030906',
      Date2: '20030906',
      Time1: '0900',
      Time2: '1800'
    },
    {
      Reason: '02',
      sName: '김수용',
      rDate: '20030905',
      chk: 1,
      Qty: 500000,
      Date1: '20030905',
      Date2: '20030905',
      Time1: '0900',
      Time2: '1800'
    },
    {
      Reason: '03',
      sName: '조문성',
      rDate: '20030905',
      chk: 0,
      Qty: 50000,
      Date1: '20030905',
      Date2: '20030905',
      Time1: '1400',
      Time2: '1500'
    },
    {
      Reason: '03',
      sName: '조문성',
      rDate: '20030905',
      chk: 1,
      Qty: 150000,
      Date1: '20030901',
      Date2: '20030902',
      Time1: '0900',
      Time2: '1800'
    },
    {
      Reason: '02',
      sName: '조문성',
      rDate: '20030830',
      chk: 0,
      Qty: 200000,
      Date1: '20030830',
      Date2: '20030830',
      Time1: '1500',
      Time2: '1800'
    },
    {
      Reason: '01',
      sName: '박진성',
      rDate: '20030611',
      chk: 0,
      Qty: 155000,
      Date1: '20030611',
      Date2: '20030611',
      Time1: '2000',
      Time2: '2200'
    },
    {
      Reason: '01',
      sName: '박진성',
      rDate: '20030508',
      chk: 1,
      Qty: 0,
      Date1: '20030508',
      Date2: '20030508',
      Time1: '0900',
      Time2: '1200'
    },
    {
      Reason: '03',
      sName: '김응주',
      rDate: '19990703',
      chk: 0,
      Qty: 155000,
      Date1: '20030611',
      Date2: '20030611',
      Time1: '0900',
      Time2: '1800'
    },
    {
      Reason: '02',
      sName: '김응주',
      rDate: '20050101',
      chk: 1,
      Qty: 0,
      Date1: '20030508',
      Date2: '20030508',
      Time1: '0900',
      Time2: '1200'
    },
    {
      Reason: '01',
      sName: '김응주',
      rDate: '20000819',
      chk: 0,
      Qty: 155000,
      Date1: '20030611',
      Date2: '20030611',
      Time1: '1500',
      Time2: '1900'
    },
    {
      Reason: '03',
      sName: '신요한',
      rDate: '20111125',
      chk: 1,
      Qty: 0,
      Date1: '20010108',
      Date2: '20030508',
      Time1: '0900',
      Time2: '1200'
    }
  ]

};

var sampleBtn = function () {
  var args = Array.prototype.slice.call(arguments, 0);

  samplePageObj.action.apply(null, args);
};
